/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH atime_user AS
  (SELECT user_name,
          atime_age,
          atime_months_lower_bound,
          SUM(size) AS size
   FROM sf_reports.last_time_generic_current
   GROUP BY user_name, atime_age, atime_months_lower_bound
   ), atime_total AS
  (SELECT user_name,
          SUM(size) AS size
   FROM atime_user
   GROUP BY user_name )
SELECT
    atime_user.user_name AS "User",
    atime_user.size / atime_total.size * 100 AS "Percent",
    atime_user.size / (1024 * 1024 * 1024.0) AS "Unaccessed (GiB)",
    atime_total.size / (1024 * 1024 * 1024.0) AS "Total (GiB)"
FROM atime_user
JOIN atime_total ON atime_user.user_name = atime_total.user_name
-- In case of custom buckets like 2-5 years, 5> years it will take only 5> years
WHERE atime_user.atime_months_lower_bound >= 36
    AND atime_user.size > atime_total.size * 0.95
    AND atime_total.size > 0
ORDER BY atime_user.size / atime_total.size DESC, atime_user.size DESC
LIMIT 20
